<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductIdentifier extends Model 
{

    protected $table = 'products_identifiers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product_abstraction()
    {
        return $this->belongsTo('App\Models\Product\ProductAbstraction', 'product_abstraction_id');
    }

    public function product_identifier_type()
    {
        return $this->belongsTo('App\Models\Product\ProductIdentifierType', 'product_identifier_type_id');
    }

}